/* hypergeometric.cp */

#include "fp.h"

/*
 Kummer's confluent hypergeometric function
 
 M(a,b,z) = 1 + (a/b)z + (a_2/b_2)z^2/2! + ... + (a_n/b_n)z^n/n! + ...
 
 where
  a_n = a(a+1)(a+2)...(a+n-1),  a_0 = 1
 
 */
 
 // we need to determine precision to use
 
 bool kummerM(fp& z, const fp& a, const fp& b, const fp& x)
 {
 	fp		res, lastResult, term;
	fp		one;
	INT32	n, aInt, bInt;
	bool	isInteger;
	 
	z = 1.;
	if(!x.i.n)
		return true;
	 
	 if(!a.i.n && !b.i.n)
		 return true;
	 
	if(!b.i.n)
		return false;
	
	isInteger = equate(bInt, b);
	if(isInteger)
	{
		if(bInt<0)
		{
			isInteger = equate(aInt, a);
			if(!isInteger)
				return false;
			if(aInt>0)
				return false;
			if(abs(aInt)>abs(bInt))
				return false;
		}
	}
	
	res = lastResult = term = 1;
	
	for(n=1; ;n++)
	{
		term = ((term*(a+n-1))/(b+n-1))*x/n;
		res = res + term;
		if(res==lastResult)
			break;
			
		lastResult = res;
	}
	 
	 z = res;
	
	return true;
 	
 }/* kummerM */


bool hyperF(fp& res, fp& a, fp& b, fp& c, fp& z)
{
 	fp		lastResult, term;
	long	n, nMax=10000;
	//long	savePrec, extraPrec;
	bool	isPrecisionGood;
	
	//savePrec = RR::prec;
	//RR::SetPrecision(savePrec+extraPrec);
	
	res = lastResult = term = 1;
	isPrecisionGood = true;
	
	for(n=1; ;n++)
	{
		term = ((term*(a+n-1)*(b+n-1))/(c+n-1))*z/n;
		res = res + term;
		if(res==lastResult)
			break;
		
		lastResult = res;
		
		 if(n>nMax)
		 {
			 isPrecisionGood = false;
			 break;
		 }
	}
	
	return isPrecisionGood;
 	
}/* hyperF */
